/*
 Copyright 2011 MYND-Ideal kft.
 Author: Barna Farago

 CSV file parser.

*/
#include "csvrow.h"

#include <iterator>
#include <iostream>


std::string const& CVSRow::operator[](std::size_t index) const
        {
            return m_data[index];
        }
std::size_t CVSRow::size() const
        {
            return m_data.size();
        }
void CVSRow::readNextRow(std::istream& str)
        {
            std::string         line;
            std::getline(str,line);

            std::stringstream   lineStream(line);
            std::string         cell;

            m_data.clear();
            while(std::getline(lineStream,cell,','))
            {
                m_data.push_back(cell);
            }
        }

int CVSRow::hexValue(int c)const
{
    if (c >= '0' && c <= '9') return c - '0';
    if (c >= 'A' && c <= 'F') return c - 'A' + 10;
    if (c >= 'a' && c <= 'f') return c - 'a' + 10;
    return -1;
}
unsigned long CVSRow::toBin(const std::string& s) const
{
    int n=s.size();
    int base= (n-1)*4;
    unsigned long value=0;
    for (int i=0; i<n; i+=1)
    {
        int x1 = hexValue(s[i]);
        //int x2 = hexValue(s[i+1]); //&& x2 >= 0
        if (x1 >= 0 ){
            unsigned char v =(x1); //*16 + x2
            value += (v<<base);
        }
        base -=4;
    }
    return value;
}
std::istream& operator>>(std::istream& str,CVSRow& data)
{
    data.readNextRow(str);
    return str;
}
