/*
 Copyright 2011 MYND-Ideal kft.
 Author: Barna Farago

 CSV file parser.

*/
#ifndef _CSVROW_H_
#define _CSVROW_H_

#include <sstream>
#include <vector>
#include <string>

// exception thrown by the encoder
class DecodeError {
public:
    DecodeError() {}
    DecodeError(const char* s): msg(s) {}
    DecodeError(const std::string& s): msg(s) {}
    const char* what() { return msg.c_str(); }
private:
    std::string msg;
};

class CVSRow
{
    public:
        std::string const& operator[](std::size_t index) const;
        unsigned long toBin(const std::string& s) const;
        std::size_t size() const;
        void readNextRow(std::istream& str);
    private:
        std::vector<std::string>    m_data;
        int hexValue(int c) const;
};

std::istream& operator>>(std::istream& str,CVSRow& data);
#endif
