/*
 Copyright 2011 MYND-Ideal kft.
 Author: Barna Farago

 Signal, Decoder.
 Used to separate Tech-tools Digiview RAW export values to signals.
 Input: delta time, signal states in binary format

*/
#include "decoder.h"


Decoder::Decoder(): m_absTime(0), m_previousValue(0)
{
}
bool Decoder::add(int dt, unsigned long value){
    bool bRet= m_previousValue!= value;
    m_absTime+=dt;
    m_changed = m_previousValue ^ value;
    m_goHigh= value & m_changed;
    m_goLow= (~value) & m_changed;
    m_previousValue=value;
    return bRet;
}
unsigned long Decoder::getValue(unsigned char from, unsigned char len){
    unsigned long mask=(unsigned long)-1;
    mask >>=(32-len);
    return (m_previousValue >>from) & mask;
}
bool Decoder::report(char* buf){
    int pos=0;
    for (int i=31; i>=0; i--){
        int mask= 1<<i;
        buf[pos]='.';
        if (mask & m_changed){
            if (mask & m_goHigh){
                buf[pos]='H';
            }
            if (mask & m_goLow){
                buf[pos]='L';
            }

        }else{
            buf[pos]='0'+ ((m_previousValue>>i)&1);
        }
         pos++;
    }
    buf[pos]=0;
    return true;
}
////////////////////

Signal::Signal(unsigned char from, unsigned char len,Decoder *decoder): m_from(from), m_len(len), m_value((unsigned long)-1),
m_wasHigh(0),m_wasLow(0),m_decoder(decoder)
{
}
void Signal::get(){
    if (!m_decoder) return;
    bool bWasLow= !m_value;
    bool bWasHigh= m_value;
    m_value=m_decoder->getValue(m_from, m_len);
    if (!m_value){
        if (bWasHigh){
            m_wasLow=m_decoder->getAbsTime();
            //m_wasHigh=0;
        }
    }
    if (m_value){
        if (bWasLow){
            m_wasHigh=m_decoder->getAbsTime();
            //m_wasLow=0;
        }
    }
}
unsigned long Signal::getValue(){
    return m_value;
}
long Signal::getTimeInLow(){
    if (!m_wasLow) return -1;
    unsigned long now= m_decoder->getAbsTime();
    long ret= now- m_wasLow;
    if (ret<0) return -1;
    return ret;
}
void Signal::clearTimeInLow(){
     if (m_value) m_wasLow=0;
}
long Signal::getTimeInHigh(){
    if (!m_wasHigh) return -1;
    unsigned long now= m_decoder->getAbsTime();
    long ret= now-m_wasHigh;
    if (!m_value) m_wasHigh=0;
    if (ret<0) return -1;
    return ret;
}
