/*
 Copyright 2011 MYND-Ideal kft.
 Author: Barna Farago

 Signal, Decoder.
 Used to separate Tech-tools Digiview RAW export values to signals.
 Input: delta time, signal states in binary format

*/
#ifndef _DECODER_H_
#define _DECODER_H_

class Decoder{
    public:
        Decoder();
        unsigned long getAbsTime(){ return m_absTime;}
        bool add(int dt, unsigned long value);
        bool report(char* buf);
        unsigned long getValue(unsigned char from, unsigned char len);
    private:
        unsigned int m_absTime;
        unsigned long m_previousValue;
        unsigned long m_changed;
        unsigned long m_goHigh;
        unsigned long m_goLow;

};

class Signal{
    public:
        Signal(unsigned char from, unsigned char len, Decoder* dec);
        void get();
        unsigned long getValue();
        long getTimeInLow();
        long getTimeInHigh();
        void clearTimeInLow();
    private:
        unsigned char m_from;
        unsigned char m_len;
        unsigned long m_value;
        unsigned long m_wasHigh;
        unsigned long m_wasLow;
        Decoder* m_decoder;
};
#endif
