/*
 Copyright 2011 MYND-Ideal kft.
 Author: Barna Farago

 IdeState
 Used to parse a Paralel ATA / IDE interface states,
 and log to standard output as human readable list.

*/
#ifndef _IDESTATE_H_
#define _IDESTATE_H_

typedef union UIdeStateErrors {
    struct {
        unsigned char ISE_wasBusyState:1;
        unsigned char ISE_wasErrorState:1;
        unsigned char ISE_missingDriveA0:1;
        unsigned char ISE_missingDevCtrl8:1;
        unsigned char ISE_missingDevCtrl1:1;
    }flags;
    unsigned long dw;
    UIdeStateErrors(){dw=0;}
} tIdeStateErrors;

class IdeState{
    public:
    enum{
        MAXIDEBUFF=256
    };
    unsigned long absTime;
    unsigned int cs;
    unsigned int addr;
    unsigned int  data;
    bool bRead;
    int dataPtr;
    unsigned short buff[MAXIDEBUFF];
    unsigned int drive;
    unsigned int head;
    unsigned long cylinder;
    unsigned int sector;
    unsigned int sectorCount;
    unsigned int sectorMultiple;
    unsigned int lastCommand;
    unsigned short deviceControl;

    bool busy;
    unsigned long busyStart;
    unsigned long busyMax;
    unsigned int busyCount;

    tIdeStateErrors errors;
    IdeState();
    void clear();
    void process();
    void report();
    void reportErrors();
};

#endif
