/*
 Copyright 2011 MYND-Ideal kft.
 Author: Barna Farago

 This is a simple command line tool, to parse IDE PATA sniffer export files.
 To understand whats happens on PATA busz while some error or instability detected.
 Input: tech-tools digiview raw export
 Output: human readable log of the IDE/Paralel.ATA bus states/commands

*/
#include <iostream>
#include <iomanip>
#include <fstream>
#include "csvrow.h"
#include "decoder.h"
#include "idestate.h"

using namespace std;

#define AFTEREDGE (0)

int main(int argc, char*argv)
{
    ifstream file("c:\\export_ALL.csv");
    CVSRow row;
    Decoder decoder;
    //RAW format file must contain the signals as the following order:
    Signal sDataBus(1,8,&decoder);
    Signal sIOW(10,1,&decoder);
    Signal sIOR(11,1,&decoder);
    Signal sCSBus(13,2,&decoder);
    Signal sAddrBus(15,3,&decoder);

    IdeState ide;

    while(file >> row)
    {
        istringstream stream(row[0]);
        int dt = 0;
        int value=row.toBin(row[1]);
        stream >> dt;
        if (decoder.add(dt, value)){
            bool bHit=false;
            sCSBus.get();
            sIOR.get();
            sIOW.get();
            unsigned int cs = sCSBus.getValue();
            if (cs !=3){
                if (ide.cs != cs) {
                    ide.cs=cs;
                    ide.absTime=decoder.getAbsTime();
                }
            }else{
                if (cs !=ide.cs) bHit=true;
            }
            long tR=sIOR.getTimeInLow();
            long tW=sIOW.getTimeInLow();
            if ((tR>=AFTEREDGE) || (tW>=AFTEREDGE)){
                if (ide.cs !=3){
                    bool inside= (!sIOR.getValue()) || (!sIOW.getValue());
                    if (inside){
                        sDataBus.get();
                        sAddrBus.get();
                        ide.addr= sAddrBus.getValue();
                        ide.data= sDataBus.getValue();
                    }
                    ide.bRead=(tR>=tW);
                    sIOR.clearTimeInLow();
                    sIOW.clearTimeInLow();
                }
            }
            if (bHit){
                bHit=false;
                ide.process();
                ide.clear();
            }
        }
    }
    ide.reportErrors();
    return 0;
}
